/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.step;

import com.quantumdata.sct.dao.vo.OptionElementVO;
import com.quantumdata.sct.dao.vo.OptionStepVO;
import com.quantumdata.sct.dao.vo.ParameterVO;
import com.quantumdata.sct.dao.vo.TestStepResultVO;
import com.quantumdata.sct.engine.EngineException;
import com.quantumdata.sct.engine.IEngineContext;
import com.quantumdata.sct.engine.step.StepEngine;
import com.quantumdata.sct.engine.step.StepEngineContext;
import com.quantumdata.sct.gui.common.SCTCheckBox;
import com.quantumdata.sct.gui.common.SCTConstants;
import com.quantumdata.sct.gui.wizard.OptionSelectionPanel;
import java.util.Properties;
import javax.swing.JPanel;

public class OptionStepEngine
extends StepEngine {
    private OptionSelectionPanel optionPanel;
    private int errorStatus = 20002;

    public OptionStepEngine(OptionStepVO optionStepVO) {
        super(optionStepVO);
    }

    public int getError() {
        return this.errorStatus;
    }

    public boolean getStatus() {
        boolean bl = true;
        OptionStepVO optionStepVO = (OptionStepVO)this.stepVO;
        for (OptionElementVO optionElementVO : optionStepVO.getOptionElements()) {
            boolean bl2 = this.optionPanel.isSelected(optionElementVO.getParmElem().getName());
            boolean bl3 = optionElementVO.isIfSelected() == bl2;
            bl &= bl3;
            if (!bl2) continue;
            this.errorStatus = 0;
        }
        return bl;
    }

    public JPanel getDisplay(Properties properties) {
        SCTCheckBox sCTCheckBox = null;
        try {
            sCTCheckBox = (SCTCheckBox)properties.get("ResultCheckBox");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.optionPanel = new OptionSelectionPanel();
        if (sCTCheckBox == null) {
            this.optionPanel.setDescription(this.stepVO.getDescription());
        } else {
            sCTCheckBox.setText(this.stepVO.getDescription());
            sCTCheckBox.setBackground(SCTConstants.qdiColor);
            this.optionPanel.setDescription(sCTCheckBox);
        }
        this.optionPanel.setChoice(((OptionStepVO)this.stepVO).isMultiChoice());
        for (OptionElementVO optionElementVO : ((OptionStepVO)this.stepVO).getOptionElements()) {
            this.optionPanel.addChoice(optionElementVO.getParmElem().getName());
        }
        this.optionPanel.init();
        return this.optionPanel;
    }

    public int execute(IEngineContext iEngineContext) throws EngineException {
        this.getStatus();
        if (this.errorStatus == 20002) {
            return this.errorStatus;
        }
        super.execute(iEngineContext);
        this.errorStatus = 20002;
        OptionStepVO optionStepVO = (OptionStepVO)this.stepVO;
        for (OptionElementVO optionElementVO : optionStepVO.getOptionElements()) {
            TestStepResultVO testStepResultVO;
            ParameterVO parameterVO = optionElementVO.getParmElem();
            boolean bl = this.optionPanel.isSelected(parameterVO.getName());
            if (bl) {
                parameterVO.setValue("selected");
            } else {
                parameterVO.setValue("not selected");
            }
            if ((testStepResultVO = ((StepEngineContext)iEngineContext).getStepResultVO()) == null) continue;
            testStepResultVO.getParameters().add(parameterVO);
        }
        return 0;
    }

    public boolean isUserStep() {
        return true;
    }
}

